import axios from "axios";

const API_BASE_URL = process.env.NEXT_PUBLIC_API_BASE_URL || "http://localhost:4000";

export const api = axios.create({ baseURL: API_BASE_URL });

export const withAuth = () => {
  if (typeof window === "undefined") return;
  const token = localStorage.getItem("admin_token");
  if (token) api.defaults.headers.common["Authorization"] = `Bearer ${token}`;
  else delete api.defaults.headers.common["Authorization"];
};
