"use client";

import { FormEvent, useState } from "react";
import { api } from "@/lib/apiClient";
import { saveAdminToken } from "@/lib/auth";
import { useRouter } from "next/navigation";

export default function LoginPage() {
  const router = useRouter();
  const [email, setEmail] = useState("");
  const [password, setPassword] = useState("");
  const [error, setError] = useState<string | null>(null);
  const [loading, setLoading] = useState(false);

  const handleSubmit = async (e: FormEvent) => {
    e.preventDefault();
    setError(null);
    setLoading(true);
    try {
      const res = await api.post("/auth/login", { email, password });
      const { token, user } = res.data;
      if (user.role !== "ADMIN") {
        setError("Not an admin user");
        setLoading(false);
        return;
      }
      saveAdminToken(token);
      router.push("/");
    } catch (err: any) {
      setError(err?.response?.data?.message || "Login failed");
    } finally {
      setLoading(false);
    }
  };

  return (
    <div
      style={{
        width: "100%",
        height: "100vh",
        display: "flex",
        alignItems: "center",
        justifyContent: "center",
        background: "#111827"
      }}
    >
      <form
        onSubmit={handleSubmit}
        style={{
          background: "white",
          padding: 24,
          borderRadius: 8,
          minWidth: 320
        }}
      >
        <h2 style={{ marginBottom: 16 }}>Admin Login</h2>
        {error && <div style={{ color: "red", marginBottom: 8, fontSize: 13 }}>{error}</div>}
        <div style={{ marginBottom: 12 }}>
          <label style={{ fontSize: 13 }}>Email</label>
          <input
            type="email"
            value={email}
            onChange={(e) => setEmail(e.target.value)}
            style={{ width: "100%", padding: 8, marginTop: 4 }}
          />
        </div>
        <div style={{ marginBottom: 16 }}>
          <label style={{ fontSize: 13 }}>Password</label>
          <input
            type="password"
            value={password}
            onChange={(e) => setPassword(e.target.value)}
            style={{ width: "100%", padding: 8, marginTop: 4 }}
          />
        </div>
        <button
          type="submit"
          disabled={loading}
          style={{
            width: "100%",
            padding: 10,
            background: "#111827",
            color: "white",
            border: "none",
            borderRadius: 4
          }}
        >
          {loading ? "Logging in..." : "Login"}
        </button>
      </form>
    </div>
  );
}
