import "./globals.css";
import type { Metadata } from "next";

export const metadata: Metadata = {
  title: "NepalStay Admin",
  description: "Admin panel for NepalStay platform"
};

export default function RootLayout({ children }: { children: React.ReactNode }) {
  return (
    <html lang="en">
      <body>
        <div style={{ display: "flex", minHeight: "100vh" }}>
          <aside
            style={{
              width: 220,
              background: "#111827",
              color: "white",
              padding: "16px"
            }}
          >
            <h2 style={{ fontSize: 22, marginBottom: 16 }}>NepalStay</h2>
            <nav style={{ display: "flex", flexDirection: "column", gap: 8 }}>
              <a href="/" style={{ color: "white" }}>Dashboard</a>
              <a href="/bookings" style={{ color: "white" }}>Bookings</a>
              <a href="/payouts" style={{ color: "white" }}>Payouts</a>
              <a href="/disputes" style={{ color: "white" }}>Disputes</a>
              <a href="/login" style={{ color: "white", marginTop: 24 }}>Logout</a>
            </nav>
          </aside>
          <main style={{ flex: 1, padding: "16px" }}>{children}</main>
        </div>
      </body>
    </html>
  );
}
